varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D 	depth;
uniform vec4		ofs;
uniform vec3		bias;
vec3	 			inputDistort; 
vec4 				color;
vec4 				colorBlur;
varying vec2		VPOS;
float kcube=ofs.z;//0.3;
float k=0.0;
float scale=ofs.y;//0.75;

void main()
{

	//index of refraction of each color channel, causing chromatic dispersion
	vec3 eta = vec3(1.0+ofs.x*0.9, 1.0+ofs.x*0.6, 1.0+ofs.x*0.3);
	
	//canvas coordinates to get the center of rendered viewport
	float r2 = (texcoord.x-0.5) * (texcoord.x-0.5) + (texcoord.y-0.5) * (texcoord.y-0.5);       
	float f = 0.0;

	//only compute the cubic distortion if necessary
	f = 1.0 + r2 * (k + kcube * sqrt(r2));
	 
	// get the right pixel for the current position
	vec2 rCoords = /*mix(texcoord.xy,*/(f*eta.r*scale)*(texcoord.xy-0.5)+0.5;//,ofs.z)+bias*0.9;
	vec2 gCoords = /*mix(texcoord.xy,*/(f*eta.g*scale)*(texcoord.xy-0.5)+0.5;//,ofs.z)+bias*0.6;
	vec2 bCoords = /*mix(texcoord.xy,*/(f*eta.b*scale)*(texcoord.xy-0.5)+0.5;//,ofs.z)+bias*0.3;

	inputDistort.r = texture2D(tex,rCoords).r;
	inputDistort.g = texture2D(tex,gCoords).g;
	inputDistort.b = texture2D(tex,bCoords).b;
	
	colorBlur.x = texture2D(depth, rCoords).x;    
	colorBlur.y = texture2D(depth, gCoords).y;   
	colorBlur.z = texture2D(depth, bCoords).z;  
	
	/*if (blurEnabled)
	{
		inputDistort.r = blur(rCoords).r;
		inputDistort.g = blur(gCoords).g;
		inputDistort.b = blur(bCoords).b;
	}*/
	
	color.rgb=mix(inputDistort.xyz,colorBlur.xyz,clamp((f-1.0)*10000.0*bias*ofs.z*ofs.x,0.0,1.0));
	gl_FragColor = vec4(color.r,color.g,color.b,1.0);
			
/*	vec2 cofs=(texcoord-vec2(0.5))*vec2(2.0);
	float occ=pow(length(cofs),2.0);

	// chromatic aberration
	vec2 tc=ofs.xy*(occ+0.5);//+d));
	
	///////////////// FISH EYE
	vec2 fishCoords;
	float dispX=(0.5-texcoord.y)*ofs.z;
	float dispX2=(0.5-texcoord.y)*dispX;
	
	dispX2=(texcoord.x-0.5)*dispX2;
	
	fishCoords.x=texcoord.x+dispX2;
	fishCoords.x=((fishCoords.x-0.5)/(1.0+(ofs.z*0.25)))+0.5;
	fishCoords.y=texcoord.y;
	///////////////////////
	
	color.x = texture2D(tex, fishCoords.xy+(vec2(-tc.x,tc.y))).x;    
	color.y = texture2D(tex, fishCoords.xy+(vec2(0.0,-tc.y))).y;   
	color.z = texture2D(tex, fishCoords.xy+(vec2(-tc.x,tc.y))).z;  
	
	colorBlur.x = texture2D(depth, fishCoords.xy+(vec2(-tc.x,tc.y))).x;    
	colorBlur.y = texture2D(depth, fishCoords.xy+(vec2(0.0,-tc.y))).y;   
	colorBlur.z = texture2D(depth, fishCoords.xy+(vec2(-tc.x,tc.y))).z;  

	float lod=min(ofs.w*occ*0.5,1.0);
	gl_FragColor.xyz = mix(color.xyz,colorBlur.xyz,lod);
	
    /*
            Cubic Lens Distortion HLSL Shader
           
            Original Lens Distortion Algorithm from SSontech (Syntheyes)
            http://www.ssontech.com/content/lensalg.htm
           
            r2 = image_aspect*image_aspect*u*u + v*v
            f = 1 + r2*(k + kcube*sqrt(r2))
            u' = f*u
            v' = f*v
     
            author : Franois Tarlier
            website : www.francois-tarlier.com/blog/index.php/2009/11/cubic-lens-distortion-shader
     
    */
     
     
   /* sampler s0 : register(s0);
     
    float4 main(float2 tex : TEXCOORD0) : COLOR
    {
           
            // lens distortion coefficient (between
            float k = -0.15;
           
            // cubic distortion value
            float kcube = 0.5;
           
           
            float r2 = (tex.x-0.5) * (tex.x-0.5) + (tex.y-0.5) * (tex.y-0.5);       
            float f = 0;
           
     
            //only compute the cubic distortion if necessary
            if( kcube == 0.0){
                    f = 1 + r2 * k;
            }else{
                    f = 1 + r2 * (k + kcube * sqrt(r2));
            };
           
            // get the right pixel for the current position
            float x = f*(tex.x-0.5)+0.5;
            float y = f*(tex.y-0.5)+0.5;
            float3 inputDistord = tex2D(s0,float2(x,y));
     
     
            return float4(inputDistord.r,inputDistord.g,inputDistord.b,1);
    }*/
	
}
